/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.buttons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.dungeons.TheBeyond;
import com.megacrit.cardcrawl.events.shrines.Lab;
import com.megacrit.cardcrawl.events.thebeyond.MysteriousSphere;
import com.megacrit.cardcrawl.events.thebottom.DeadAdventurer;
import com.megacrit.cardcrawl.events.thebottom.Mushrooms;
import com.megacrit.cardcrawl.events.thecity.MaskedBandits;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.EventRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.rooms.VictoryRoom;
import com.megacrit.cardcrawl.ui.FtueTip;

public class ProceedButton {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Rewards Tip");
    public static final String[] MSG = ProceedButton.tutorialStrings.TEXT;
    public static final String[] LABEL = ProceedButton.tutorialStrings.LABEL;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("Proceed Button");
    public static final String[] TEXT = ProceedButton.uiStrings.TEXT;
    private static final Color HOVER_BLEND_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.3f);
    private static final float SHOW_X = 1670.0f * Settings.scale;
    private static final float DRAW_Y = 320.0f * Settings.scale;
    private static final float HIDE_X = SHOW_X + 500.0f * Settings.scale;
    private float current_x = HIDE_X;
    private float current_y = DRAW_Y;
    private float target_x = this.current_x;
    private float wavyTimer = 0.0f;
    private boolean isHidden = true;
    private String label = TEXT[0];
    private static final int W = 512;
    private BitmapFont font = FontHelper.buttonLabelFont;
    private static final float HITBOX_W = 280.0f * Settings.scale;
    private static final float HITBOX_H = 156.0f * Settings.scale;
    private Hitbox hitbox = new Hitbox(SHOW_X, this.current_y, HITBOX_W, HITBOX_H);
    private static final float CLICKABLE_DIST = 25.0f * Settings.scale;
    public boolean isHovered = false;

    public ProceedButton() {
        this.hitbox.move(SHOW_X, this.current_y);
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
        this.font = FontHelper.getSmartWidth(FontHelper.buttonLabelFont, this.label, 9999.0f, 0.0f) > 160.0f * Settings.scale ? FontHelper.topPanelInfoFont : FontHelper.buttonLabelFont;
    }

    public void update() {
        if (!this.isHidden) {
            this.wavyTimer += Gdx.graphics.getDeltaTime() * 3.0f;
            if (this.current_x - SHOW_X < CLICKABLE_DIST) {
                this.hitbox.update();
            }
            this.isHovered = this.hitbox.hovered;
            if (this.hitbox.hovered && InputHelper.justClickedLeft) {
                CardCrawlGame.sound.play("UI_CLICK_1");
                this.hitbox.clickStarted = true;
            }
            if (this.hitbox.justHovered && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
                for (RewardItem i : AbstractDungeon.combatRewardScreen.rewards) {
                    i.flash();
                }
            }
            if (this.hitbox.hovered && this.hitbox.clicked) {
                MapRoomNode node;
                this.hitbox.hovered = false;
                this.hitbox.clicked = false;
                AbstractRoom currentRoom = AbstractDungeon.getCurrRoom();
                if (currentRoom instanceof MonsterRoomBoss && CardCrawlGame.dungeon instanceof TheBeyond) {
                    CardCrawlGame.music.fadeOutBGM();
                    CardCrawlGame.music.fadeOutTempBGM();
                    node = new MapRoomNode(-1, 15);
                    node.room = new VictoryRoom();
                    AbstractDungeon.nextRoom = node;
                    AbstractDungeon.closeCurrentScreen();
                    AbstractDungeon.nextRoomTransitionStart();
                    this.hide();
                }
                if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD && !(AbstractDungeon.getCurrRoom() instanceof TreasureRoomBoss)) {
                    if (currentRoom instanceof MonsterRoomBoss) {
                        CardCrawlGame.music.fadeOutTempBGM();
                        node = new MapRoomNode(-1, 15);
                        node.room = new TreasureRoomBoss();
                        AbstractDungeon.nextRoom = node;
                        AbstractDungeon.closeCurrentScreen();
                        AbstractDungeon.nextRoomTransitionStart();
                        this.hide();
                    } else if (currentRoom instanceof EventRoom) {
                        if (!(currentRoom.event instanceof Mushrooms || currentRoom.event instanceof MaskedBandits || currentRoom.event instanceof DeadAdventurer || currentRoom.event instanceof Lab || currentRoom.event instanceof MysteriousSphere)) {
                            AbstractDungeon.closeCurrentScreen();
                            this.hide();
                        } else {
                            AbstractDungeon.closeCurrentScreen();
                            AbstractDungeon.dungeonMapScreen.open(false);
                            AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
                        }
                    } else {
                        if (!TipTracker.tips.get("CARD_REWARD_TIP").booleanValue() && !AbstractDungeon.combatRewardScreen.rewards.isEmpty()) {
                            AbstractDungeon.ftue = new FtueTip(LABEL[0], MSG[0], (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, FtueTip.TipType.CARD_REWARD);
                            TipTracker.neverShowAgain("CARD_REWARD_TIP");
                            return;
                        }
                        AbstractDungeon.closeCurrentScreen();
                        AbstractDungeon.dungeonMapScreen.open(false);
                        AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
                    }
                } else if (currentRoom instanceof TreasureRoomBoss) {
                    if (Settings.isDemo) {
                        node = new MapRoomNode(-1, 15);
                        node.room = new VictoryRoom();
                        AbstractDungeon.nextRoom = node;
                        AbstractDungeon.closeCurrentScreen();
                        AbstractDungeon.nextRoomTransitionStart();
                        this.hide();
                    } else {
                        if (!((TreasureRoomBoss)currentRoom).choseRelic) {
                            AbstractDungeon.bossRelicScreen.noPick();
                        }
                        CardCrawlGame.music.fadeOutBGM();
                        CardCrawlGame.music.fadeOutTempBGM();
                        CardCrawlGame.sound.fadeOut(AbstractMonster.STINGER_KEY, AbstractMonster.STINGER_ID);
                        AbstractDungeon.fadeOut();
                        AbstractDungeon.isDungeonBeaten = true;
                        this.hide();
                    }
                } else if (!(currentRoom instanceof MonsterRoomBoss)) {
                    AbstractDungeon.dungeonMapScreen.open(false);
                    this.hide();
                }
            }
        }
        if (this.current_x != this.target_x) {
            this.current_x = MathUtils.lerp(this.current_x, this.target_x, Gdx.graphics.getDeltaTime() * 9.0f);
            if (Math.abs(this.current_x - this.target_x) < Settings.UI_SNAP_THRESHOLD) {
                this.current_x = this.target_x;
            }
        }
    }

    public void hideInstantly() {
        this.current_x = HIDE_X;
        this.target_x = HIDE_X;
        this.isHidden = true;
    }

    public void hide() {
        if (!this.isHidden) {
            this.target_x = HIDE_X;
            this.isHidden = true;
        }
    }

    public void show() {
        if (this.isHidden) {
            this.target_x = SHOW_X;
            this.isHidden = false;
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        this.renderShadow(sb);
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
            sb.setColor(new Color(1.0f, 0.9f, 0.2f, MathUtils.cos(this.wavyTimer) / 5.0f + 0.6f));
        } else {
            sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
        }
        sb.draw(ImageMaster.PROCEED_BUTTON_OUTLINE, this.current_x - 256.0f, this.current_y - 256.0f, 256.0f, 256.0f, 512.0f, 512.0f, Settings.scale * 1.1f + MathUtils.cos(this.wavyTimer) / 50.0f, Settings.scale * 1.1f + MathUtils.cos(this.wavyTimer) / 50.0f, 0.0f, 0, 0, 512, 512, false, false);
        sb.setColor(Color.WHITE);
        this.renderButton(sb);
        if (this.hitbox.hovered) {
            sb.setBlendFunction(770, 1);
            sb.setColor(HOVER_BLEND_COLOR);
            this.renderButton(sb);
            sb.setBlendFunction(770, 771);
        }
        if (this.hitbox.hovered && !this.hitbox.clickStarted) {
            FontHelper.renderFontCentered(sb, this.font, this.label, this.current_x, this.current_y, Settings.CREAM_COLOR);
        } else if (this.hitbox.clickStarted) {
            FontHelper.renderFontCentered(sb, this.font, this.label, this.current_x, this.current_y, Color.LIGHT_GRAY);
        } else {
            FontHelper.renderFontCentered(sb, this.font, this.label, this.current_x, this.current_y, Settings.LIGHT_YELLOW_COLOR);
        }
        if (!this.isHidden) {
            this.hitbox.render(sb);
        }
    }

    private void renderShadow(SpriteBatch sb) {
        sb.draw(ImageMaster.PROCEED_BUTTON_SHADOW, this.current_x - 256.0f, this.current_y - 256.0f, 256.0f, 256.0f, 512.0f, 512.0f, Settings.scale * 1.1f + MathUtils.cos(this.wavyTimer) / 50.0f, Settings.scale * 1.1f + MathUtils.cos(this.wavyTimer) / 50.0f, 0.0f, 0, 0, 512, 512, false, false);
    }

    private void renderButton(SpriteBatch sb) {
        sb.draw(ImageMaster.PROCEED_BUTTON, this.current_x - 256.0f, this.current_y - 256.0f, 256.0f, 256.0f, 512.0f, 512.0f, Settings.scale * 1.1f + MathUtils.cos(this.wavyTimer) / 50.0f, Settings.scale * 1.1f + MathUtils.cos(this.wavyTimer) / 50.0f, 0.0f, 0, 0, 512, 512, false, false);
    }
}

